/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.compat.lwgl;

import com.mojang.blaze3d.systems.GpuDevice;
import fi.dy.masa.malilib.MaLiLib;

public class GpuCompat {
    private static String GPUVendor = "";
    private static String GPURenderer = "";
    private static String GPUVersion = "";

    public static void init(GpuDevice device) {
        GPUVendor = device.getVendor();
        GPURenderer = device.getRenderer();
        GPUVersion = device.getVersion();
        MaLiLib.debugLog("Detected GPU: [{} / {}]", GPURenderer, GPUVersion);
    }

    public static String getVendor() {
        return GPUVendor;
    }

    public static String getRenderer() {
        return GPURenderer;
    }

    public static String getVersion() {
        return GPUVersion;
    }

    public static boolean isNvidiaGpu() {
        return GPURenderer.toLowerCase().contains("nvidia");
    }

    public static boolean isAmdGpu() {
        return GPURenderer.toLowerCase().contains("amd") || GpuCompat.getVendor().toLowerCase().contains("ati");
    }

    public static boolean isIntelGpu() {
        return GPURenderer.toLowerCase().contains("intel");
    }
}

