/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric.internal;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.internal.FabricEntity;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Location;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import org.jetbrains.annotations.Nullable;

public class FabricServerLevelDelegateProxy
implements InvocationHandler,
AutoCloseable {
    private final EditSession editSession;
    private final class_3218 serverLevel;
    private final Map<BlockVector3, class_2586> createdBlockEntities = new HashMap<BlockVector3, class_2586>();

    private FabricServerLevelDelegateProxy(EditSession editSession, class_3218 serverLevel) {
        this.editSession = editSession;
        this.serverLevel = serverLevel;
    }

    public static LevelAndProxy newInstance(EditSession editSession, class_3218 serverLevel) {
        FabricServerLevelDelegateProxy proxy = new FabricServerLevelDelegateProxy(editSession, serverLevel);
        return new LevelAndProxy((class_5281)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)proxy), proxy);
    }

    @Nullable
    private class_2586 getBlockEntity(class_2338 blockPos) {
        BlockVector3 pos = FabricAdapter.adapt(blockPos);
        return this.createdBlockEntities.get(pos);
    }

    private class_2680 getBlockState(class_2338 blockPos) {
        return FabricAdapter.adapt(this.editSession.getBlockWithBuffer(FabricAdapter.adapt(blockPos)));
    }

    private boolean setBlock(class_2338 blockPos, class_2680 blockState) {
        try {
            this.handleBlockEntity(blockPos, blockState);
            return this.editSession.setBlock(FabricAdapter.adapt(blockPos), FabricAdapter.adapt(blockState));
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleBlockEntity(class_2338 blockPos, class_2680 blockState) {
        BlockVector3 pos = FabricAdapter.adapt(blockPos);
        if (blockState.method_31709()) {
            class_2248 class_22482 = blockState.method_26204();
            if (!(class_22482 instanceof class_2343)) {
                throw new AssertionError((Object)("BlockState has block entity but block is not an EntityBlock: " + String.valueOf(blockState)));
            }
            class_2343 entityBlock = (class_2343)class_22482;
            class_2586 newEntity = entityBlock.method_10123(blockPos, blockState);
            if (newEntity != null) {
                newEntity.method_31664(blockState);
                this.createdBlockEntities.put(pos, newEntity);
                return;
            }
        }
        this.createdBlockEntities.remove(pos);
    }

    private boolean removeBlock(class_2338 blockPos, boolean bl) {
        return this.setBlock(blockPos, class_2246.field_10124.method_9564());
    }

    private boolean addEntity(class_1297 entity) {
        BaseEntity baseEntity;
        Vector3 pos = FabricAdapter.adapt(entity.method_30950(0.0f));
        Location location = new Location((Extent)FabricAdapter.adapt((class_1937)this.serverLevel), pos.x(), pos.y(), pos.z());
        return this.editSession.createEntity(location, baseEntity = new FabricEntity(entity).getState()) != null;
    }

    @Override
    public void close() throws MaxChangedBlocksException {
        for (Map.Entry<BlockVector3, class_2586> entry : this.createdBlockEntities.entrySet()) {
            BlockVector3 blockPos = entry.getKey();
            class_2586 blockEntity = entry.getValue();
            this.editSession.setBlock(blockPos, FabricAdapter.adapt(blockEntity, this.serverLevel.method_30349()));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getBlockState": 
            case "method_8320": {
                Object object;
                if (args.length != 1 || !((object = args[0]) instanceof class_2338)) break;
                class_2338 blockPos = (class_2338)object;
                return this.getBlockState(blockPos);
            }
            case "isStateAtPosition": 
            case "method_16358": {
                Object object;
                if (args.length != 2 || !((object = args[0]) instanceof class_2338)) break;
                class_2338 blockPos = (class_2338)object;
                if (!(args[1] instanceof Predicate)) break;
                Predicate predicate = (Predicate)args[1];
                return predicate.test(this.getBlockState(blockPos));
            }
            case "getBlockEntity": 
            case "method_8321": {
                Object predicate;
                if (args.length != 1 || !((predicate = args[0]) instanceof class_2338)) break;
                class_2338 blockPos = (class_2338)predicate;
                return this.getBlockEntity(blockPos);
            }
            case "setBlock": 
            case "method_8652": {
                Object object;
                if (args.length < 2 || !((object = args[0]) instanceof class_2338)) break;
                class_2338 blockPos = (class_2338)object;
                object = args[1];
                if (!(object instanceof class_2680)) break;
                class_2680 blockState = (class_2680)object;
                return this.setBlock(blockPos, blockState);
            }
            case "removeBlock": 
            case "destroyBlock": 
            case "method_8650": 
            case "method_8651": {
                Object object;
                if (args.length < 2 || !((object = args[0]) instanceof class_2338)) break;
                class_2338 blockPos = (class_2338)object;
                object = args[1];
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                return this.removeBlock(blockPos, bl);
            }
            case "addEntity": 
            case "method_14175": 
            case "addFreshEntityWithPassengers": 
            case "method_30771": {
                Object object;
                if (args.length < 1 || !((object = args[0]) instanceof class_1297)) break;
                class_1297 entity = (class_1297)object;
                return this.addEntity(entity);
            }
        }
        return method.invoke((Object)this.serverLevel, args);
    }

    public record LevelAndProxy(class_5281 level, FabricServerLevelDelegateProxy proxy) implements AutoCloseable
    {
        @Override
        public void close() throws MaxChangedBlocksException {
            this.proxy.close();
        }
    }
}

