/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;

public abstract class AccessorImpl<T extends class_239>
implements Accessor<T> {
    private final class_1937 level;
    private final class_1657 player;
    private final Supplier<T> hit;
    private final boolean serverConnected;
    private final boolean showDetails;
    private class_2487 serverData;
    protected boolean verify;
    private class_9129 buffer;

    public AccessorImpl(class_1937 level, class_1657 player, @Nullable class_2487 serverData, Supplier<T> hit, boolean serverConnected, boolean showDetails) {
        this.level = Objects.requireNonNull(level);
        this.player = Objects.requireNonNull(player);
        this.hit = Objects.requireNonNull(hit);
        this.serverConnected = serverConnected;
        this.showDetails = showDetails;
        this.setServerData(serverData);
    }

    @Override
    public class_1937 getLevel() {
        return this.level;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public final class_2487 getServerData() {
        return this.serverData;
    }

    @Override
    @Deprecated
    public final void setServerData(@Nullable class_2487 serverData) {
        this.serverData = serverData == null ? new class_2487() : serverData;
    }

    private class_9129 buffer() {
        if (this.buffer == null) {
            this.buffer = new class_9129(Unpooled.buffer(), this.level.method_30349());
        }
        this.buffer.method_52931();
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <D> Optional<D> decodeFromNbt(class_9141<class_9129, D> codec, class_2520 tag) {
        try {
            class_9129 buffer = this.buffer();
            buffer.method_52983(((class_2479)tag).method_10521());
            Object decoded = codec.decode((Object)buffer);
            Optional<Object> optional = Optional.of(decoded);
            return optional;
        }
        catch (Exception e) {
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.buffer.method_52931();
        }
    }

    @Override
    public <D> class_2520 encodeAsNbt(class_9142<class_9129, D> streamCodec, D value) {
        class_9129 buffer = this.buffer();
        streamCodec.encode((Object)buffer, value);
        class_2479 tag = new class_2479(ArrayUtils.subarray((byte[])buffer.array(), (int)0, (int)buffer.readableBytes()));
        buffer.method_52931();
        return tag;
    }

    @Override
    public T getHitResult() {
        return (T)((class_239)this.hit.get());
    }

    @Override
    public boolean isServerConnected() {
        return this.serverConnected;
    }

    @Override
    public boolean showDetails() {
        return this.showDetails;
    }

    @Override
    public abstract class_1799 getPickedResult();

    public void requireVerification() {
        this.verify = true;
    }

    @Override
    public float tickRate() {
        return this.getLevel().method_54719().method_54748();
    }
}

