/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.Orientation;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.ui.ResizeableElement;
import snownee.jade.api.ui.TextElement;
import snownee.jade.api.view.ProgressView;
import snownee.jade.gui.PinScreen;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.BoxElementImpl;
import snownee.jade.impl.ui.FluidStackElement;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.impl.ui.ProgressElement;
import snownee.jade.impl.ui.SimpleProgressStyle;
import snownee.jade.impl.ui.SpacerElement;
import snownee.jade.impl.ui.SpriteElement;
import snownee.jade.impl.ui.TextElementImpl;
import snownee.jade.overlay.DisplayHelper;

public class JadeUIInternal {
    public static final class_2960 DEFAULT_PROGRESS = JadeIds.JADE("progress");
    public static final class_2960 DEFAULT_PROGRESS_BASE = JadeIds.JADE("progress_base");
    private static class_2960 contextUid;

    public static boolean isEmptyElement(Element element) {
        return element == null;
    }

    public static TextElement text(class_2561 component) {
        return new TextElementImpl(component);
    }

    public static Element item(class_1799 stack, float scale, @Nullable String text) {
        return ItemStackElement.of(stack, scale, text);
    }

    public static Element smallItem(class_1799 stack) {
        Objects.requireNonNull(DisplayHelper.font());
        int lineHeight = 9;
        return JadeUIInternal.item(stack, 0.5f, "").size(lineHeight + 1, lineHeight - 1).offset(0, -1).narration("");
    }

    public static ResizeableElement fluid(JadeFluidObject fluid) {
        return new FluidStackElement(fluid);
    }

    public static ResizeableElement spacer(int width, int height) {
        return new SpacerElement(width, height);
    }

    public static Element progressArrow(float progress) {
        return JadeUIInternal.progress(progress, DEFAULT_PROGRESS_BASE, DEFAULT_PROGRESS, 22, 16, null, null);
    }

    public static ResizeableElement progress(ProgressView view) {
        return new ProgressElement(view);
    }

    public static ResizeableElement progress(ProgressView view, int width, int height) {
        return new ProgressElement(view, width, height);
    }

    public static ResizeableElement progress(float progress, class_2960 baseSprite, class_2960 progressSprite, int width, int height, @Nullable class_2561 text, @Nullable ProgressStyle style) {
        return JadeUIInternal.progress(new ProgressView(ProgressView.Part.of(progress, JadeUIInternal.sprite(progressSprite, width, height)), text, style == null ? JadeUIInternal.progressStyle().fitContentX(false).fitContentY(false) : style, BoxStyle.sprite(baseSprite, null, 0)), width, height);
    }

    public static BoxElement box(ITooltip tooltip, BoxStyle boxStyle) {
        return new BoxElementImpl((Tooltip)tooltip, boxStyle);
    }

    public static ITooltip tooltip(@Nullable Element icon) {
        Tooltip tooltip = new Tooltip();
        if (icon != null) {
            tooltip.setIcon(icon);
        }
        return tooltip;
    }

    public static ProgressStyle progressStyle() {
        return new SimpleProgressStyle();
    }

    public static ResizeableElement sprite(RenderPipeline renderPipeline, class_2960 sprite, int width, int height) {
        return new SpriteElement(renderPipeline, sprite, width, height);
    }

    public static ResizeableElement sprite(class_2960 sprite, int width, int height) {
        return new SpriteElement(sprite, width, height);
    }

    public static ResizeableElement offset(Element element, int x, int y) {
        return ((SpacerElement)JadeUIInternal.spacer(element.method_25368(), element.method_25364())).wrapped(element).offset(x, y);
    }

    public static ResizeableElement size(Element element, int width, int height) {
        return ((SpacerElement)JadeUIInternal.spacer(width, height)).wrapped(element);
    }

    public static ResizeableElement onClick(Element element, Predicate<Element> onClick) {
        return JadeUIInternal.offset(element, 0, 0).onClick(onClick);
    }

    @Nullable
    public static class_2960 contextUid() {
        return contextUid;
    }

    public static void setContextUid(@Nullable class_2960 uid) {
        contextUid = uid;
    }

    public static void visitChildrenRecursive(class_8021 layoutElement, Consumer<class_8021> consumer) {
        JadeUIInternal.visitChildrenRecursiveInternal(layoutElement, consumer, Sets.newIdentityHashSet());
    }

    private static void visitChildrenRecursiveInternal(class_8021 layoutElement, Consumer<class_8021> consumer, Set<class_8021> set) {
        if (layoutElement == null || !set.add(layoutElement)) {
            return;
        }
        consumer.accept(layoutElement);
        if (layoutElement instanceof BoxElement) {
            return;
        }
        if (layoutElement instanceof class_8133) {
            class_8133 layout = (class_8133)layoutElement;
            layout.method_48227(element -> JadeUIInternal.visitChildrenRecursiveInternal(element, consumer, set));
        } else {
            layoutElement.method_48206(widget -> JadeUIInternal.visitChildrenRecursiveInternal((class_8021)widget, consumer, set));
        }
    }

    public static ResizeableElement horizontalTiledSprite(RenderPipeline renderPipeline, class_2960 sprite, int width, int height) {
        SpriteElement element = (SpriteElement)JadeUIInternal.sprite(renderPipeline, sprite, width, height);
        element.tiledOrientation = Orientation.HORIZONTAL;
        return element;
    }

    public static ResizeableElement verticalTiledSprite(RenderPipeline renderPipeline, class_2960 sprite, int width, int height) {
        SpriteElement element = (SpriteElement)JadeUIInternal.sprite(renderPipeline, sprite, width, height);
        element.tiledOrientation = Orientation.VERTICAL;
        return element;
    }

    public static boolean isPinned() {
        return class_310.method_1551().field_1755 instanceof PinScreen;
    }
}

