/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.config;

import com.google.gson.FieldNamingPolicy;
import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.config.Config;
import com.qendolin.betterclouds.config.Migrations;
import com.qendolin.betterclouds.config.ShaderPresetConfig;
import com.qendolin.betterclouds.platform.ModLoader;
import com.qendolin.betterclouds.util.PreLaunchGuard;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.commons.io.FilenameUtils;

public class ConfigManager {
    public static final Path CONFIG_PATH = ModLoader.getConfigDir().resolve("betterclouds-v1.json");
    public static final class_2960 CONFIG_ID = class_2960.method_60655((String)"betterclouds", (String)"betterclouds-v1");
    private static ConfigClassHandler<Config> config;

    public static ConfigClassHandler<Config> handler() {
        if (config == null) {
            throw new IllegalStateException("Config accessed before it was initialized");
        }
        return config;
    }

    public static Config instance() {
        if (config == null) {
            throw new IllegalStateException("Config accessed before it was initialized");
        }
        return (Config)config.instance();
    }

    public static boolean isInitialized() {
        return config != null;
    }

    public static void initialize() {
        if (!BetterCloudsStatic.IS_CLIENT || ConfigManager.isInitialized()) {
            return;
        }
        ConfigManager.config = ConfigClassHandler.createBuilder(Config.class).id(CONFIG_ID).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).appendGsonBuilder(b -> b.setLenient().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().registerTypeAdapter(Config.class, Config.INSTANCE_CREATOR).registerTypeAdapter(ShaderPresetConfig.class, ShaderPresetConfig.INSTANCE_CREATOR).registerTypeAdapter(class_5321.class, (Object)Config.REGISTRY_KEY_SERIALIZER)).setPath(CONFIG_PATH).setJson5(false).build()).build();
    }

    public static void loadWithFailureBackup() {
        assert (config != null);
        try {
            config.load();
            Migrations.migrate((Config)config.instance());
            return;
        }
        catch (Exception e) {
            BetterCloudsStatic.getLogger().error("Failed to load config", (Throwable)e);
            File file = CONFIG_PATH.toFile();
            if (file.exists() && file.isFile()) {
                String backupName = FilenameUtils.getBaseName((String)file.getName()) + "-backup-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + FilenameUtils.getExtension((String)file.getName());
                Path backup = Path.of(CONFIG_PATH.toAbsolutePath().getParent().toString(), backupName);
                try {
                    Files.copy(file.toPath(), backup, StandardCopyOption.REPLACE_EXISTING);
                    BetterCloudsStatic.getLogger().info("Created config backup at: {}", backup);
                }
                catch (Exception backupException) {
                    BetterCloudsStatic.getLogger().error("Failed to create config backup: ", (Throwable)backupException);
                }
            } else if (file.exists() && file.delete()) {
                BetterCloudsStatic.getLogger().info("Deleted old config");
            }
            try {
                config.save();
                BetterCloudsStatic.getLogger().info("Created new config");
                config.load();
            }
            catch (Exception loadException) {
                BetterCloudsStatic.getLogger().error("Failed to load config again, please report this issue: ", (Throwable)loadException);
            }
            return;
        }
    }

    static {
        PreLaunchGuard.check();
    }
}

