/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import com.google.common.collect.Iterables;
import io.github.a5b84.helditeminfo.HeldItemInfo;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public final class ContainerContentAppender {
    private ContainerContentAppender() {
    }

    public static void appendContainerContent(TooltipBuilder builder) {
        builder.appendComponent(class_9334.field_49626);
        for (ContainerEntry containerEntry : ContainerContentAppender.getContainerEntries(builder)) {
            builder.append(() -> class_2561.method_43469((String)"item.container.item_count", (Object[])new Object[]{innerStack.getName(), innerStack.getCount()}).method_27692(TooltipBuilder.DEFAULT_COLOR));
        }
    }

    private static Iterable<? extends ContainerEntry> getContainerEntries(TooltipBuilder builder) {
        Optional bundleContents;
        Iterable<Object> stacks = Collections.emptyList();
        Optional containerComponent = builder.getComponentForDisplay(class_9334.field_49622);
        if (containerComponent.isPresent()) {
            stacks = ((class_9288)containerComponent.get()).method_59714();
        }
        if ((bundleContents = builder.getComponentForDisplay(class_9334.field_49650)).isPresent()) {
            stacks = Iterables.concat(stacks, (Iterable)((class_9276)bundleContents.get()).method_57421());
        }
        if (HeldItemInfo.config.mergeSimilarContainerItems()) {
            LinkedHashMap<class_2561, MergedContainerEntry> entries = new LinkedHashMap<class_2561, MergedContainerEntry>();
            for (class_1799 class_17992 : stacks) {
                entries.compute(class_17992.method_7964(), (name, entry) -> {
                    if (entry == null) {
                        entry = new MergedContainerEntry((class_2561)name);
                    }
                    entry.count += stack.method_7947();
                    return entry;
                });
            }
            return entries.values();
        }
        return Iterables.transform(stacks, ItemStackContainerEntry::new);
    }

    private static abstract class ContainerEntry {
        private ContainerEntry() {
        }

        public abstract class_2561 getName();

        public abstract int getCount();
    }

    private static class MergedContainerEntry
    extends ContainerEntry {
        private final class_2561 name;
        private int count = 0;

        private MergedContainerEntry(class_2561 name) {
            this.name = name;
        }

        @Override
        public class_2561 getName() {
            return this.name;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    private static class ItemStackContainerEntry
    extends ContainerEntry {
        private final class_1799 stack;

        public ItemStackContainerEntry(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public class_2561 getName() {
            return this.stack.method_7964();
        }

        @Override
        public int getCount() {
            return this.stack.method_7947();
        }
    }
}

