/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.types;

import com.seibel.distanthorizons.core.config.ConfigHandler;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.listeners.IConfigListener;
import com.seibel.distanthorizons.core.config.types.AbstractConfigBase;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryAppearance;
import com.seibel.distanthorizons.core.config.types.enums.EConfigValidity;
import com.seibel.distanthorizons.core.util.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ConfigEntry<T>
extends AbstractConfigBase<T> {
    private final String comment;
    private T min;
    private T max;
    private final ArrayList<IConfigListener> listenerList;
    private final String chatCommandName;
    private final boolean allowApiOverride;
    @Nullable
    private T apiValue;

    private ConfigEntry(EConfigEntryAppearance appearance, String comment, String chatCommandName, T value, T min, T max, boolean allowApiOverride, ArrayList<IConfigListener> listenerList) {
        super(appearance, value);
        this.comment = comment;
        this.min = min;
        this.max = max;
        this.chatCommandName = chatCommandName;
        this.allowApiOverride = allowApiOverride;
        this.listenerList = listenerList;
    }

    public String getChatCommandName() {
        return this.chatCommandName;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean getAllowApiOverride() {
        return this.allowApiOverride;
    }

    public T getMin() {
        return this.min;
    }

    public void setMin(T newMin) {
        this.min = newMin;
    }

    public T getMax() {
        return this.max;
    }

    public void setMax(T newMax) {
        this.max = newMax;
    }

    public void setApiValue(T newApiValue) {
        this.apiValue = newApiValue;
        this.listenerList.forEach(IConfigListener::onConfigValueSet);
    }

    public boolean apiIsOverriding() {
        return this.allowApiOverride && this.apiValue != null;
    }

    public void setWithoutFiringEvents(T newValue) {
        super.set(newValue);
    }

    public void setWithoutSaving(T newValue) {
        super.set(newValue);
        this.listenerList.forEach(IConfigListener::onConfigValueSet);
    }

    @Override
    public void set(T newValue) {
        this.setWithoutSaving(newValue);
        this.save();
    }

    public void uiSetWithoutSaving(T newValue) {
        this.setWithoutSaving(newValue);
        this.listenerList.forEach(IConfigListener::onUiModify);
    }

    public void uiSet(T newValue) {
        this.set(newValue);
        this.listenerList.forEach(IConfigListener::onUiModify);
    }

    @Override
    public T get() {
        if (this.allowApiOverride && this.apiValue != null) {
            return this.apiValue;
        }
        return super.get();
    }

    public T getTrueValue() {
        return super.get();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public T getApiValue() {
        return this.apiValue;
    }

    public void addValueChangeListener(Consumer<T> onValueChangeFunc) {
        ConfigChangeListener<T> changeListener = new ConfigChangeListener<T>(this, onValueChangeFunc);
        this.addListener(changeListener);
    }

    public void addListener(IConfigListener newListener) {
        this.listenerList.add(newListener);
    }

    public void removeListener(IConfigListener oldListener) {
        this.listenerList.remove(oldListener);
    }

    public void clearListeners() {
        this.listenerList.clear();
    }

    public ArrayList<IConfigListener> getListeners() {
        return this.listenerList;
    }

    public void setListeners(ArrayList<IConfigListener> newListeners) {
        this.listenerList.clear();
        this.listenerList.addAll(newListeners);
    }

    public void setListeners(IConfigListener ... newListeners) {
        this.listenerList.addAll(Arrays.asList(newListeners));
    }

    public EConfigValidity getValidity() {
        return this.getValidity(this.value, this.min, this.max);
    }

    public EConfigValidity getValidity(@Nullable T value) {
        return this.getValidity(value, this.min, this.max);
    }

    public EConfigValidity getValidity(@Nullable T value, @Nullable T min, @Nullable T max) {
        if (!ConfigHandler.INSTANCE.runMinMaxValidation) {
            return EConfigValidity.VALID;
        }
        if (min == null && max == null) {
            return EConfigValidity.VALID;
        }
        if (value == null || this.value == null || value.getClass() != this.value.getClass()) {
            return EConfigValidity.INVALID;
        }
        if (value instanceof Number) {
            if (max != null && NumberUtil.greaterThan((Number)value, (Number)max)) {
                return EConfigValidity.NUMBER_TOO_HIGH;
            }
            if (min != null && NumberUtil.lessThan((Number)value, (Number)min)) {
                return EConfigValidity.NUMBER_TOO_LOW;
            }
            return EConfigValidity.VALID;
        }
        return EConfigValidity.VALID;
    }

    public void save() {
        ConfigHandler.INSTANCE.configFileHandler.saveEntry(this);
    }

    public void load() {
        ConfigHandler.INSTANCE.configFileHandler.loadEntry(this);
    }

    public boolean equals(AbstractConfigBase<?> obj) {
        return obj.getClass() == ConfigEntry.class && this.equals((ConfigEntry)obj);
    }

    public boolean equals(ConfigEntry<?> obj) {
        if (Number.class.isAssignableFrom(this.value.getClass())) {
            return this.value == obj.value;
        }
        return this.value.equals(obj.value);
    }

    public static class Builder<T>
    extends AbstractConfigBase.Builder<T, Builder<T>> {
        private String tmpComment = null;
        private T tmpMin = null;
        private T tmpMax = null;
        protected String tmpChatCommandName = null;
        private boolean tmpUseApiOverwrite = true;
        protected ArrayList<IConfigListener> tmpIConfigListener = new ArrayList();

        public Builder<T> comment(String newComment) {
            this.tmpComment = newComment;
            return this;
        }

        public Builder<T> setMinDefaultMax(T newMin, T newDefault, T newMax) {
            this.set((Object)newDefault);
            this.setMinMax(newMin, newMax);
            return this;
        }

        public Builder<T> setMinMax(T newMin, T newMax) {
            this.tmpMin = newMin;
            this.tmpMax = newMax;
            return this;
        }

        public Builder<T> setMin(T newMin) {
            this.tmpMin = newMin;
            return this;
        }

        public Builder<T> setMax(T newMax) {
            this.tmpMax = newMax;
            return this;
        }

        public Builder<T> setChatCommandName(String name) {
            this.tmpChatCommandName = name;
            return this;
        }

        public Builder<T> setUseApiOverwrite(boolean newUseApiOverwrite) {
            this.tmpUseApiOverwrite = newUseApiOverwrite;
            return this;
        }

        public Builder<T> replaceListeners(ArrayList<IConfigListener> newConfigListener) {
            this.tmpIConfigListener = newConfigListener;
            return this;
        }

        public Builder<T> addListeners(IConfigListener ... newConfigListener) {
            this.tmpIConfigListener.addAll(Arrays.asList(newConfigListener));
            return this;
        }

        public Builder<T> addListener(IConfigListener newConfigListener) {
            this.tmpIConfigListener.add(newConfigListener);
            return this;
        }

        public Builder<T> clearListeners() {
            this.tmpIConfigListener.clear();
            return this;
        }

        public ConfigEntry<T> build() {
            return new ConfigEntry(this.tmpAppearance, this.tmpComment, this.tmpChatCommandName, this.tmpValue, this.tmpMin, this.tmpMax, this.tmpUseApiOverwrite, this.tmpIConfigListener);
        }
    }
}

