/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.level.IServerKeyedClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.ClientBlockStateColorCache;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.class_1959;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientLevelWrapper
implements IClientLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(ClientLevelWrapper.class.getSimpleName());
    private static final Map<class_638, WeakReference<ClientLevelWrapper>> LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    private static final class_310 MINECRAFT = class_310.method_1551();
    private final class_638 level;
    private final ConcurrentHashMap<class_2680, ClientBlockStateColorCache> blockCache = new ConcurrentHashMap();
    private final Function<class_2680, ClientBlockStateColorCache> cachedBlockColorCacheFunction = blockState -> this.createBlockColorCache((class_2680)blockState);
    private BlockStateWrapper dirtBlockWrapper;
    private BlockStateWrapper waterBlockWrapper;
    private BiomeWrapper plainsBiomeWrapper;
    @Deprecated
    private IDhLevel parentDhLevel;

    protected ClientLevelWrapper(class_638 level) {
        this.level = level;
    }

    @Nullable
    public static IClientLevelWrapper getWrapperIfDifferent(@Nullable IClientLevelWrapper levelWrapper, @NotNull class_638 level) {
        if (KEYED_CLIENT_LEVEL_MANAGER.isEnabled() && KEYED_CLIENT_LEVEL_MANAGER.getServerKeyedLevel() != levelWrapper) {
            return ClientLevelWrapper.getWrapper(level);
        }
        ClientLevelWrapper clientLevelWrapper = (ClientLevelWrapper)levelWrapper;
        if (clientLevelWrapper == null || clientLevelWrapper.level != level) {
            return ClientLevelWrapper.getWrapper(level);
        }
        return clientLevelWrapper;
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@NotNull class_638 level) {
        return ClientLevelWrapper.getWrapper(level, false);
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@Nullable class_638 level, boolean bypassLevelKeyManager) {
        ClientLevelWrapper levelWrapper;
        WeakReference<ClientLevelWrapper> levelRef;
        if (!bypassLevelKeyManager) {
            if (level == null) {
                return null;
            }
            IServerKeyedClientLevel overrideLevel = KEYED_CLIENT_LEVEL_MANAGER.getServerKeyedLevel();
            if (overrideLevel != null) {
                return overrideLevel;
            }
        }
        if ((levelRef = LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.get(level)) != null && (levelWrapper = (ClientLevelWrapper)levelRef.get()) != null) {
            return levelWrapper;
        }
        return (IClientLevelWrapper)LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.compute(level, (newLevel, newLevelRef) -> {
            ClientLevelWrapper oldLevelWrapper;
            if (newLevelRef != null && (oldLevelWrapper = (ClientLevelWrapper)newLevelRef.get()) != null) {
                return newLevelRef;
            }
            return new WeakReference<ClientLevelWrapper>(new ClientLevelWrapper((class_638)newLevel));
        }).get();
    }

    @Override
    @Nullable
    public IServerLevelWrapper tryGetServerSideWrapper() {
        try {
            Iterable serverLevels = MINECRAFT.method_1576().method_3738();
            ServerLevelWrapper foundLevelWrapper = null;
            for (class_3218 serverLevel : serverLevels) {
                if (serverLevel.method_27983() != this.level.method_27983()) continue;
                foundLevelWrapper = ServerLevelWrapper.getWrapper(serverLevel);
                break;
            }
            return foundLevelWrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get server side wrapper for client level: " + String.valueOf(this.level));
            return null;
        }
    }

    @Override
    public int getBlockColor(DhBlockPos pos, IBiomeWrapper biome, FullDataSourceV2 fullDataSource, IBlockStateWrapper blockWrapper) {
        ClientBlockStateColorCache blockColorCache = this.blockCache.computeIfAbsent(((BlockStateWrapper)blockWrapper).blockState, this.cachedBlockColorCacheFunction);
        return blockColorCache.getColor((BiomeWrapper)biome, fullDataSource, pos);
    }

    private ClientBlockStateColorCache createBlockColorCache(class_2680 block) {
        return new ClientBlockStateColorCache(block, this);
    }

    @Override
    public int getDirtBlockColor() {
        if (this.dirtBlockWrapper == null) {
            try {
                this.dirtBlockWrapper = (BlockStateWrapper)BlockStateWrapper.deserialize("minecraft:dirt", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get dirt color with resource location [minecraft:dirt] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return -1;
            }
        }
        return this.getBlockColor(DhBlockPos.ZERO, BiomeWrapper.EMPTY_WRAPPER, null, this.dirtBlockWrapper);
    }

    @Override
    public int getWaterBlockColor() {
        if (this.waterBlockWrapper == null) {
            try {
                this.waterBlockWrapper = (BlockStateWrapper)BlockStateWrapper.deserialize("minecraft:water", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get water color with resource location [minecraft:water] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return -1;
            }
        }
        return this.getBlockColor(DhBlockPos.ZERO, BiomeWrapper.EMPTY_WRAPPER, null, this.waterBlockWrapper);
    }

    @Override
    public void clearBlockColorCache() {
        this.blockCache.clear();
    }

    @Override
    public IBiomeWrapper getPlainsBiomeWrapper() {
        if (this.plainsBiomeWrapper == null) {
            try {
                this.plainsBiomeWrapper = (BiomeWrapper)BiomeWrapper.deserialize("minecraft:plains", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get planes biome with resource location [minecraft:plains] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return null;
            }
        }
        return this.plainsBiomeWrapper;
    }

    @Override
    public IDimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.method_8597());
    }

    @Override
    public String getDimensionName() {
        return this.level.method_27983().method_29177().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.method_22385().field_20641;
    }

    @Override
    public String getDhIdentifier() {
        return this.getHashedSeedEncoded() + "@" + this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.CLIENT_LEVEL;
    }

    public class_638 getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.method_8597().comp_643();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.method_8597().comp_642();
    }

    @Override
    public int getMaxHeight() {
        return this.level.method_31605();
    }

    @Override
    public int getMinHeight() {
        return this.level.method_31607();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.method_8393(pos.getX(), pos.getZ())) {
            return null;
        }
        class_2791 chunk = this.level.method_8402(pos.getX(), pos.getZ(), class_2806.field_12798, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        class_631 source = this.level.method_2935();
        return source.method_12123(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.method_8320(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((class_6880<class_1959>)this.level.method_23753(McObjectConverter.Convert(pos)), this);
    }

    public class_638 getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.remove(this.level);
        this.parentDhLevel = null;
    }

    @Override
    public File getDhSaveFolder() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getSaveStructure().getSaveFolder(this);
    }

    @Override
    public void setParentLevel(IDhLevel parentLevel) {
        this.parentDhLevel = parentLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getGenericRenderer();
    }

    @Override
    public Color getCloudColor(float tickDelta) {
        int argbColor = this.level.method_23785(tickDelta);
        return ColorUtil.toColorObjARGB(argbColor);
    }

    public String toString() {
        if (this.level == null) {
            return "Wrapped{null}";
        }
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

