/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lzma;

import java.io.IOException;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;
import org.tukaani.xz.lzma.LZMACoder;
import org.tukaani.xz.lzma.LZMAEncoderFast;
import org.tukaani.xz.lzma.LZMAEncoderNormal;
import org.tukaani.xz.lzma.State;
import org.tukaani.xz.rangecoder.RangeEncoder;

public abstract class LZMAEncoder
extends LZMACoder {
    public static final int MODE_FAST = 1;
    public static final int MODE_NORMAL = 2;
    private static final int LZMA2_UNCOMPRESSED_LIMIT = 0x1FFEEF;
    private static final int LZMA2_COMPRESSED_LIMIT = 65510;
    private static final int DIST_PRICE_UPDATE_INTERVAL = 128;
    private static final int ALIGN_PRICE_UPDATE_INTERVAL = 16;
    private final RangeEncoder rc;
    final LZEncoder lz;
    final LiteralEncoder literalEncoder;
    final LengthEncoder matchLenEncoder;
    final LengthEncoder repLenEncoder;
    final int niceLen;
    private int distPriceCount = 0;
    private int alignPriceCount = 0;
    private final int distSlotPricesSize;
    private final int[][] distSlotPrices;
    private final int[][] fullDistPrices = new int[4][128];
    private final int[] alignPrices = new int[16];
    int back = 0;
    int readAhead = -1;
    private int uncompressedSize = 0;

    public static int getMemoryUsage(int i, int j, int k, int l) {
        int n = 80;
        switch (i) {
            case 1: {
                n += LZMAEncoderFast.getMemoryUsage(j, k, l);
                break;
            }
            case 2: {
                n += LZMAEncoderNormal.getMemoryUsage(j, k, l);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n;
    }

    public static LZMAEncoder getInstance(RangeEncoder rangeEncoder, int i, int j, int k, int l, int m, int n, int o, int p, int q, ArrayCache arrayCache) {
        switch (l) {
            case 1: {
                return new LZMAEncoderFast(rangeEncoder, i, j, k, m, n, o, p, q, arrayCache);
            }
            case 2: {
                return new LZMAEncoderNormal(rangeEncoder, i, j, k, m, n, o, p, q, arrayCache);
            }
        }
        throw new IllegalArgumentException();
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        this.lz.putArraysToCache(arrayCache);
    }

    public static int getDistSlot(int i) {
        if (i <= 4 && i >= 0) {
            return i;
        }
        int n = i;
        int n2 = 31;
        if ((n & 0xFFFF0000) == 0) {
            n <<= 16;
            n2 = 15;
        }
        if ((n & 0xFF000000) == 0) {
            n <<= 8;
            n2 -= 8;
        }
        if ((n & 0xF0000000) == 0) {
            n <<= 4;
            n2 -= 4;
        }
        if ((n & 0xC0000000) == 0) {
            n <<= 2;
            n2 -= 2;
        }
        if ((n & Integer.MIN_VALUE) == 0) {
            --n2;
        }
        return (n2 << 1) + (i >>> n2 - 1 & 1);
    }

    abstract int getNextSymbol();

    LZMAEncoder(RangeEncoder rangeEncoder, LZEncoder lZEncoder, int i, int j, int k, int l, int m) {
        super(k);
        this.rc = rangeEncoder;
        this.lz = lZEncoder;
        this.niceLen = m;
        this.literalEncoder = new LiteralEncoder(i, j);
        this.matchLenEncoder = new LengthEncoder(k, m);
        this.repLenEncoder = new LengthEncoder(k, m);
        this.distSlotPricesSize = LZMAEncoder.getDistSlot(l - 1) + 1;
        this.distSlotPrices = new int[4][this.distSlotPricesSize];
        this.reset();
    }

    public LZEncoder getLZEncoder() {
        return this.lz;
    }

    @Override
    public void reset() {
        super.reset();
        this.literalEncoder.reset();
        this.matchLenEncoder.reset();
        this.repLenEncoder.reset();
        this.distPriceCount = 0;
        this.alignPriceCount = 0;
        this.uncompressedSize += this.readAhead + 1;
        this.readAhead = -1;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void resetUncompressedSize() {
        this.uncompressedSize = 0;
    }

    public void encodeForLZMA1() throws IOException {
        if (!this.lz.isStarted() && !this.encodeInit()) {
            return;
        }
        while (this.encodeSymbol()) {
        }
    }

    public void encodeLZMA1EndMarker() throws IOException {
        int n = this.lz.getPos() - this.readAhead & this.posMask;
        this.rc.encodeBit(this.isMatch[this.state.get()], n, 1);
        this.rc.encodeBit(this.isRep, this.state.get(), 0);
        this.encodeMatch(-1, 2, n);
    }

    public boolean encodeForLZMA2() {
        try {
            if (!this.lz.isStarted() && !this.encodeInit()) {
                return false;
            }
            while (this.uncompressedSize <= 0x1FFEEF && this.rc.getPendingSize() <= 65510) {
                if (this.encodeSymbol()) continue;
                return false;
            }
        }
        catch (IOException iOException) {
            throw new Error();
        }
        return true;
    }

    private boolean encodeInit() throws IOException {
        assert (this.readAhead == -1);
        if (!this.lz.hasEnoughData(0)) {
            return false;
        }
        this.skip(1);
        this.rc.encodeBit(this.isMatch[this.state.get()], 0, 0);
        this.literalEncoder.encodeInit();
        --this.readAhead;
        assert (this.readAhead == -1);
        ++this.uncompressedSize;
        assert (this.uncompressedSize == 1);
        return true;
    }

    private boolean encodeSymbol() throws IOException {
        if (!this.lz.hasEnoughData(this.readAhead + 1)) {
            return false;
        }
        int n = this.getNextSymbol();
        assert (this.readAhead >= 0);
        int n2 = this.lz.getPos() - this.readAhead & this.posMask;
        if (this.back == -1) {
            assert (n == 1);
            this.rc.encodeBit(this.isMatch[this.state.get()], n2, 0);
            this.literalEncoder.encode();
        } else {
            this.rc.encodeBit(this.isMatch[this.state.get()], n2, 1);
            if (this.back < 4) {
                assert (this.lz.getMatchLen(-this.readAhead, this.reps[this.back], n) == n);
                this.rc.encodeBit(this.isRep, this.state.get(), 1);
                this.encodeRepMatch(this.back, n, n2);
            } else {
                assert (this.lz.getMatchLen(-this.readAhead, this.back - 4, n) == n);
                this.rc.encodeBit(this.isRep, this.state.get(), 0);
                this.encodeMatch(this.back - 4, n, n2);
            }
        }
        this.readAhead -= n;
        this.uncompressedSize += n;
        return true;
    }

    private void encodeMatch(int i, int j, int k) throws IOException {
        this.state.updateMatch();
        this.matchLenEncoder.encode(j, k);
        int n = LZMAEncoder.getDistSlot(i);
        this.rc.encodeBitTree(this.distSlots[LZMAEncoder.getDistState(j)], n);
        if (n >= 4) {
            int n2 = (n >>> 1) - 1;
            int n3 = (2 | n & 1) << n2;
            int n4 = i - n3;
            if (n < 14) {
                this.rc.encodeReverseBitTree(this.distSpecial[n - 4], n4);
            } else {
                this.rc.encodeDirectBits(n4 >>> 4, n2 - 4);
                this.rc.encodeReverseBitTree(this.distAlign, n4 & 0xF);
                --this.alignPriceCount;
            }
        }
        this.reps[3] = this.reps[2];
        this.reps[2] = this.reps[1];
        this.reps[1] = this.reps[0];
        this.reps[0] = i;
        --this.distPriceCount;
    }

    private void encodeRepMatch(int i, int j, int k) throws IOException {
        if (i == 0) {
            this.rc.encodeBit(this.isRep0, this.state.get(), 0);
            this.rc.encodeBit(this.isRep0Long[this.state.get()], k, j == 1 ? 0 : 1);
        } else {
            int n = this.reps[i];
            this.rc.encodeBit(this.isRep0, this.state.get(), 1);
            if (i == 1) {
                this.rc.encodeBit(this.isRep1, this.state.get(), 0);
            } else {
                this.rc.encodeBit(this.isRep1, this.state.get(), 1);
                this.rc.encodeBit(this.isRep2, this.state.get(), i - 2);
                if (i == 3) {
                    this.reps[3] = this.reps[2];
                }
                this.reps[2] = this.reps[1];
            }
            this.reps[1] = this.reps[0];
            this.reps[0] = n;
        }
        if (j == 1) {
            this.state.updateShortRep();
        } else {
            this.repLenEncoder.encode(j, k);
            this.state.updateLongRep();
        }
    }

    Matches getMatches() {
        ++this.readAhead;
        Matches matches = this.lz.getMatches();
        assert (this.lz.verifyMatches(matches));
        return matches;
    }

    void skip(int i) {
        this.readAhead += i;
        this.lz.skip(i);
    }

    int getAnyMatchPrice(State state, int i) {
        return RangeEncoder.getBitPrice(this.isMatch[state.get()][i], 1);
    }

    int getNormalMatchPrice(int i, State state) {
        return i + RangeEncoder.getBitPrice(this.isRep[state.get()], 0);
    }

    int getAnyRepPrice(int i, State state) {
        return i + RangeEncoder.getBitPrice(this.isRep[state.get()], 1);
    }

    int getShortRepPrice(int i, State state, int j) {
        return i + RangeEncoder.getBitPrice(this.isRep0[state.get()], 0) + RangeEncoder.getBitPrice(this.isRep0Long[state.get()][j], 0);
    }

    int getLongRepPrice(int i, int j, State state, int k) {
        int n = i;
        if (j == 0) {
            n += RangeEncoder.getBitPrice(this.isRep0[state.get()], 0) + RangeEncoder.getBitPrice(this.isRep0Long[state.get()][k], 1);
        } else {
            n += RangeEncoder.getBitPrice(this.isRep0[state.get()], 1);
            n = j == 1 ? (n += RangeEncoder.getBitPrice(this.isRep1[state.get()], 0)) : (n += RangeEncoder.getBitPrice(this.isRep1[state.get()], 1) + RangeEncoder.getBitPrice(this.isRep2[state.get()], j - 2));
        }
        return n;
    }

    int getLongRepAndLenPrice(int i, int j, State state, int k) {
        int n = this.getAnyMatchPrice(state, k);
        int n2 = this.getAnyRepPrice(n, state);
        int n3 = this.getLongRepPrice(n2, i, state, k);
        return n3 + this.repLenEncoder.getPrice(j, k);
    }

    int getMatchAndLenPrice(int i, int j, int k, int l) {
        int n = i + this.matchLenEncoder.getPrice(k, l);
        int n2 = LZMAEncoder.getDistState(k);
        if (j < 128) {
            n += this.fullDistPrices[n2][j];
        } else {
            int n3 = LZMAEncoder.getDistSlot(j);
            n += this.distSlotPrices[n2][n3] + this.alignPrices[j & 0xF];
        }
        return n;
    }

    private void updateDistPrices() {
        int n;
        int n2;
        int n3;
        this.distPriceCount = 128;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < this.distSlotPricesSize; ++n2) {
                this.distSlotPrices[n3][n2] = RangeEncoder.getBitTreePrice(this.distSlots[n3], n2);
            }
            n2 = 14;
            while (n2 < this.distSlotPricesSize) {
                n = (n2 >>> 1) - 1 - 4;
                int[] nArray = this.distSlotPrices[n3];
                int n4 = n2++;
                nArray[n4] = nArray[n4] + RangeEncoder.getDirectBitsPrice(n);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                this.fullDistPrices[n3][n2] = this.distSlotPrices[n3][n2];
            }
        }
        n3 = 4;
        for (n2 = 4; n2 < 14; ++n2) {
            n = (n2 >>> 1) - 1;
            int n5 = (2 | n2 & 1) << n;
            int n6 = this.distSpecial[n2 - 4].length;
            for (int i = 0; i < n6; ++i) {
                int n7 = n3 - n5;
                int n8 = RangeEncoder.getReverseBitTreePrice(this.distSpecial[n2 - 4], n7);
                for (int j = 0; j < 4; ++j) {
                    this.fullDistPrices[j][n3] = this.distSlotPrices[j][n2] + n8;
                }
                ++n3;
            }
        }
        assert (n3 == 128);
    }

    private void updateAlignPrices() {
        this.alignPriceCount = 16;
        for (int i = 0; i < 16; ++i) {
            this.alignPrices[i] = RangeEncoder.getReverseBitTreePrice(this.distAlign, i);
        }
    }

    void updatePrices() {
        if (this.distPriceCount <= 0) {
            this.updateDistPrices();
        }
        if (this.alignPriceCount <= 0) {
            this.updateAlignPrices();
        }
        this.matchLenEncoder.updatePrices();
        this.repLenEncoder.updatePrices();
    }

    class LiteralEncoder
    extends LZMACoder.LiteralCoder {
        private final LiteralSubencoder[] subencoders;

        LiteralEncoder(int i, int j) {
            super(i, j);
            this.subencoders = new LiteralSubencoder[1 << i + j];
            for (int k = 0; k < this.subencoders.length; ++k) {
                this.subencoders[k] = new LiteralSubencoder();
            }
        }

        void reset() {
            for (int i = 0; i < this.subencoders.length; ++i) {
                this.subencoders[i].reset();
            }
        }

        void encodeInit() throws IOException {
            assert (LZMAEncoder.this.readAhead >= 0);
            this.subencoders[0].encode();
        }

        void encode() throws IOException {
            assert (LZMAEncoder.this.readAhead >= 0);
            int n = this.getSubcoderIndex(LZMAEncoder.this.lz.getByte(1 + LZMAEncoder.this.readAhead), LZMAEncoder.this.lz.getPos() - LZMAEncoder.this.readAhead);
            this.subencoders[n].encode();
        }

        int getPrice(int i, int j, int k, int l, State state) {
            int n = RangeEncoder.getBitPrice(LZMAEncoder.this.isMatch[state.get()][l & LZMAEncoder.this.posMask], 0);
            int n2 = this.getSubcoderIndex(k, l);
            return n += state.isLiteral() ? this.subencoders[n2].getNormalPrice(i) : this.subencoders[n2].getMatchedPrice(i, j);
        }

        private class LiteralSubencoder
        extends LZMACoder.LiteralCoder.LiteralSubcoder {
            private LiteralSubencoder() {
            }

            void encode() throws IOException {
                int n = LZMAEncoder.this.lz.getByte(LZMAEncoder.this.readAhead) | 0x100;
                if (LZMAEncoder.this.state.isLiteral()) {
                    do {
                        int n2 = n >>> 8;
                        int n3 = n >>> 7 & 1;
                        LZMAEncoder.this.rc.encodeBit(this.probs, n2, n3);
                    } while ((n <<= 1) < 65536);
                } else {
                    int n4 = LZMAEncoder.this.lz.getByte(LZMAEncoder.this.reps[0] + 1 + LZMAEncoder.this.readAhead);
                    int n5 = 256;
                    do {
                        int n6 = (n4 <<= 1) & n5;
                        int n7 = n5 + n6 + (n >>> 8);
                        int n8 = n >>> 7 & 1;
                        LZMAEncoder.this.rc.encodeBit(this.probs, n7, n8);
                        n5 &= ~(n4 ^ (n <<= 1));
                    } while (n < 65536);
                }
                LZMAEncoder.this.state.updateLiteral();
            }

            int getNormalPrice(int i) {
                int n = 0;
                i |= 0x100;
                do {
                    int n2 = i >>> 8;
                    int n3 = i >>> 7 & 1;
                    n += RangeEncoder.getBitPrice(this.probs[n2], n3);
                } while ((i <<= 1) < 65536);
                return n;
            }

            int getMatchedPrice(int i, int j) {
                int n = 0;
                int n2 = 256;
                i |= 0x100;
                do {
                    int n3 = (j <<= 1) & n2;
                    int n4 = n2 + n3 + (i >>> 8);
                    int n5 = i >>> 7 & 1;
                    n += RangeEncoder.getBitPrice(this.probs[n4], n5);
                    n2 &= ~(j ^ (i <<= 1));
                } while (i < 65536);
                return n;
            }
        }
    }

    class LengthEncoder
    extends LZMACoder.LengthCoder {
        private static final int PRICE_UPDATE_INTERVAL = 32;
        private final int[] counters;
        private final int[][] prices;

        LengthEncoder(int i, int j) {
            int n = 1 << i;
            this.counters = new int[n];
            int n2 = Math.max(j - 2 + 1, 16);
            this.prices = new int[n][n2];
        }

        @Override
        void reset() {
            super.reset();
            for (int i = 0; i < this.counters.length; ++i) {
                this.counters[i] = 0;
            }
        }

        void encode(int i, int j) throws IOException {
            if ((i -= 2) < 8) {
                LZMAEncoder.this.rc.encodeBit(this.choice, 0, 0);
                LZMAEncoder.this.rc.encodeBitTree(this.low[j], i);
            } else {
                LZMAEncoder.this.rc.encodeBit(this.choice, 0, 1);
                if ((i -= 8) < 8) {
                    LZMAEncoder.this.rc.encodeBit(this.choice, 1, 0);
                    LZMAEncoder.this.rc.encodeBitTree(this.mid[j], i);
                } else {
                    LZMAEncoder.this.rc.encodeBit(this.choice, 1, 1);
                    LZMAEncoder.this.rc.encodeBitTree(this.high, i - 8);
                }
            }
            int n = j;
            this.counters[n] = this.counters[n] - 1;
        }

        int getPrice(int i, int j) {
            return this.prices[j][i - 2];
        }

        void updatePrices() {
            for (int i = 0; i < this.counters.length; ++i) {
                if (this.counters[i] > 0) continue;
                this.counters[i] = 32;
                this.updatePrices(i);
            }
        }

        private void updatePrices(int i) {
            int n;
            int n2 = RangeEncoder.getBitPrice(this.choice[0], 0);
            for (n = 0; n < 8; ++n) {
                this.prices[i][n] = n2 + RangeEncoder.getBitTreePrice(this.low[i], n);
            }
            n2 = RangeEncoder.getBitPrice(this.choice[0], 1);
            int n3 = RangeEncoder.getBitPrice(this.choice[1], 0);
            while (n < 16) {
                this.prices[i][n] = n2 + n3 + RangeEncoder.getBitTreePrice(this.mid[i], n - 8);
                ++n;
            }
            n3 = RangeEncoder.getBitPrice(this.choice[1], 1);
            while (n < this.prices[i].length) {
                this.prices[i][n] = n2 + n3 + RangeEncoder.getBitTreePrice(this.high, n - 8 - 8);
                ++n;
            }
        }
    }
}

