/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.LightyPipelines;
import dev.schmarrn.lighty.core.RendererRegistry;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10896;
import net.minecraft.class_11282;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class LightyRenderer {
    private static final Vector4f UNIT_COLOR_MODULATOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Matrix4f DEFAULT_TEXTURE_MATRIX = new Matrix4f();

    public static int addData(class_4076 chunkSection, class_10896 gpuBuffer, class_243 camPos, int biggestBufferSize, List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, List<class_11282.class_11283> transforms) {
        class_243 origin = new class_243((class_2382)chunkSection.method_19767());
        class_243 dPos = origin.method_1020(camPos);
        if (gpuBuffer.method_68544() == null && gpuBuffer.method_68546() > biggestBufferSize) {
            biggestBufferSize = gpuBuffer.method_68546();
        }
        int currentTransformationIndex = transforms.size();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        modelViewMatrix.translate((float)dPos.method_10216(), (float)dPos.method_10214(), (float)dPos.method_10215());
        transforms.add(new class_11282.class_11283((Matrix4fc)modelViewMatrix, (Vector4fc)UNIT_COLOR_MODULATOR, (Vector3fc)new Vector3f(), (Matrix4fc)DEFAULT_TEXTURE_MATRIX, 1.0f));
        drawList.add((RenderPass.class_10884<GpuBufferSlice[]>)new RenderPass.class_10884(0, gpuBuffer.method_68540(), gpuBuffer.method_68544(), gpuBuffer.method_68547(), 0, gpuBuffer.method_68546(), (bufferSlice, uniformUploader) -> uniformUploader.upload("DynamicTransforms", bufferSlice[currentTransformationIndex])));
        return biggestBufferSize;
    }

    private static int goThroughEachBuffer(class_310 minecraft, class_4184 camera, class_243 camPos, class_4604 frustum, List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, List<class_11282.class_11283> transforms, Object2ObjectOpenHashMap<class_4076, BufferHolder> cache) {
        int biggestBufferSize = 0;
        ObjectIterator cacheIterator = cache.object2ObjectEntrySet().fastIterator();
        while (cacheIterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
            class_4076 chunkSection = (class_4076)entry.getKey();
            BufferHolder cachedBuffer = (BufferHolder)entry.getValue();
            Object2ObjectOpenHashMap<class_2960, class_10896> gpuBuffers = cachedBuffer.getGpuBuffers();
            ObjectIterator bufferIterator = gpuBuffers.object2ObjectEntrySet().fastIterator();
            while (bufferIterator.hasNext()) {
                Object2ObjectMap.Entry bufferEntry = (Object2ObjectMap.Entry)bufferIterator.next();
                if (!cachedBuffer.isValid((class_2960)bufferEntry.getKey())) continue;
                biggestBufferSize = LightyRenderer.addData(chunkSection, (class_10896)bufferEntry.getValue(), camPos, biggestBufferSize, drawList, transforms);
            }
        }
        return biggestBufferSize;
    }

    private static DrawListData prepareData(class_310 minecraft, class_4604 frustum, Object2ObjectOpenHashMap<class_4076, BufferHolder> cache) {
        class_4184 camera = minecraft.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        ArrayList<RenderPass.class_10884<GpuBufferSlice[]>> drawList = new ArrayList<RenderPass.class_10884<GpuBufferSlice[]>>();
        ArrayList<class_11282.class_11283> transforms = new ArrayList<class_11282.class_11283>();
        int biggestBufferSize = LightyRenderer.goThroughEachBuffer(minecraft, camera, camPos, frustum, drawList, transforms, cache);
        GpuBufferSlice[] dynamicTransforms = RenderSystem.getDynamicUniforms().method_71107(transforms.toArray(new class_11282.class_11283[0]));
        return new DrawListData(drawList, biggestBufferSize, dynamicTransforms);
    }

    public static void render(DrawListData data) {
        class_276 renderTarget;
        if (!SMACH.isEnabled()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        OverlayRenderer renderer = RendererRegistry.getRenderer();
        GpuDevice device = RenderSystem.getDevice();
        GpuTextureView tex = minecraft.method_1531().method_4619(renderer.getTextureLocation()).method_71659();
        GpuTextureView backupTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)tex);
        RenderPipeline pipeline = renderer.getPipeline();
        class_276 class_2762 = renderTarget = renderer.getPipeline() == LightyPipelines.TERRAIN_TRANSLUCENT ? minecraft.field_1769.method_29360() : minecraft.method_1522();
        if (renderTarget == null) {
            renderTarget = minecraft.method_1522();
        }
        RenderSystem.class_5590 asib = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer baseIndexBuffer = data.maxIndicesRequired == 0 ? null : asib.method_68274(data.maxIndicesRequired);
        VertexFormat.class_5595 baseIndexType = data.maxIndicesRequired == 0 ? null : asib.method_31924();
        try (RenderPass pass = device.createCommandEncoder().createRenderPass(() -> "Lighty Render Pass for" + String.valueOf(pipeline.getLocation()), renderTarget.method_71639(), OptionalInt.empty(), renderTarget.method_71640(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.bindSampler("Sampler2", minecraft.field_1773.method_22974().method_71650());
            pass.setPipeline(pipeline);
            pass.bindSampler("Sampler0", tex);
            pass.drawMultipleIndexed(pipeline == LightyPipelines.TERRAIN_TRANSLUCENT ? data.drawList.reversed() : data.drawList, baseIndexBuffer, baseIndexType, List.of("DynamicTransforms"), (Object)data.dynamicTransforms);
        }
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)backupTexture);
    }

    public record DrawListData(List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, int maxIndicesRequired, GpuBufferSlice[] dynamicTransforms) {
    }
}

